--** --------------------------------------------------------------
--** Command Center Project Dabase
--** Database Script Version 7
--** 
--** WARNING: 
--** 
--**
--** DATE: May 18, 2007
--** VERSION: 2
--** --------------------------------------------------------------

--***************************************************************************
--*
--* Create/Alter Table
--*
--***************************************************************************
alter TABLE [dbo].[MonitoringCfgQuestionsThatCount] 
   alter column [QuestionAlias] [varchar] (5)  NOT NULL 

GO

IF NOT EXISTS (
	SELECT * FROM INFORMATION_SCHEMA.TABLES AS info
	INNER JOIN sys.objects AS o ON o.[Name]=info.[TABLE_NAME]
	INNER JOIN sys.indexes AS idx ON idx.[object_id]=o.[object_id]
	WHERE o.[type_desc]='USER_TABLE' AND idx.[name]='IxStrStratum' AND info.[TABLE_NAME]='Stratum'

)
CREATE INDEX [IxStrStratum] ON Stratum ([StrStratum]) ON [PRIMARY]
GO

IF NOT EXISTS (
	SELECT * FROM INFORMATION_SCHEMA.TABLES AS info
	INNER JOIN sys.objects AS o ON o.[Name]=info.[TABLE_NAME]
	INNER JOIN sys.indexes AS idx ON idx.[object_id]=o.[object_id]
	WHERE o.[type_desc]='USER_TABLE' AND idx.[name]='IxStrRespondent' AND info.[TABLE_NAME]='Stratum'
)
CREATE INDEX [IxStrRespondent] ON Stratum ([StrRespondent]) ON [PRIMARY]
GO

IF NOT EXISTS (
	SELECT * FROM INFORMATION_SCHEMA.TABLES AS info
	INNER JOIN sys.objects AS o ON o.[Name]=info.[TABLE_NAME]
	INNER JOIN sys.indexes AS idx ON idx.[object_id]=o.[object_id]
	WHERE o.[type_desc]='USER_TABLE' AND idx.[name]='IxRpsQuestion' AND info.[TABLE_NAME]='Response'
)
CREATE INDEX [IxRpsQuestion] ON Response ([RpsQuestion]) ON [PRIMARY]
GO

IF NOT EXISTS (
	SELECT * FROM INFORMATION_SCHEMA.TABLES AS info
	INNER JOIN sys.objects AS o ON o.[Name]=info.[TABLE_NAME]
	INNER JOIN sys.indexes AS idx ON idx.[object_id]=o.[object_id]
	WHERE o.[type_desc]='USER_TABLE' AND idx.[name]='IxRpsQuestionContent' AND info.[TABLE_NAME]='Response'
)
CREATE INDEX [IxRpsQuestionContent] ON Response ([RpsQuestion],[RpsRespondent],[RpsContent]) ON [PRIMARY]
GO

IF NOT EXISTS (
	SELECT * FROM INFORMATION_SCHEMA.TABLES AS info
	INNER JOIN sys.objects AS o ON o.[Name]=info.[TABLE_NAME]
	INNER JOIN sys.indexes AS idx ON idx.[object_id]=o.[object_id]
	WHERE o.[type_desc]='USER_TABLE' AND idx.[name]='IxResCallBackDate' AND info.[TABLE_NAME]='Respondent'
)
CREATE INDEX [IxResCallBackDate] ON Respondent ([ResCallbackDate]) ON [PRIMARY]
GO

